use final.dta, clear

set seed 3141592

*Table 2: Dispute Occurrence Using Full Latent Measure and Including Non-Allied Dyads
logit dispute chall_tar_affin rel_power contig seqdispute  if pol_rel ==1, robust
	est store all_dis
logit dispute chall_tar_affin tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1 , robust
	est store all_dis2
logit dispute chall_tar_affin def_affin_target of_affin_chall neu_affin_chall rel_power contig seqdispute  if pol_rel ==1 , robust
	est store all_dis3
logit dispute chall_tar_affin def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1  , robust 
	est store all_dis4
	
esttab all_dis all_dis2 all_dis3 all_dis4 using t2.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model") ///
	   	    varlabels(chall_tar_affin "Chal.-Target Affinity" def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger"tar_defense "Defense to Target" chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Cahl.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons) 
	
*Figure 1: Substantive Effect for Defensive Cultural Affinity in Table 2 Dispute Model
	margins, at(def_affin_target=(-.5(0.5)2.5) tar_defense=(1))
			marginsplot, recast(line)    recastci(rarea) ciopt(color(%40)) ///
			 note(Shaded area represents 95% CI)   ///
				ylabel( #5, grid)  ///
				xlabel(-.5(.5)2.5)     ///
				ytitle("Probability of Dispute Initiation")   ///
				xtitle("Cultural Affinity of Defense Alliance of Target")    ///
				graphregion(fcolor(white)) ///
				title("Dispute Initiation by Affinity of Defense Alliance of Target", size(*1)) ///
				saving(dispute, replace)
	
*Table 3: War Occurrence Using Full Latent Measure and Including Non-Allied Dyads
logit war chall_tar_affin rel_power contig seqdispute if pol_rel ==1 , robust
	est store all_war
logit war tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 , robust
	est store all_war2
logit war def_affin_target of_affin_chall neu_affin_chall chall_tar_affin rel_power contig seqdispute if pol_rel ==1  , robust
	est store all_war3
logit war def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 , robust
	est store all_war4
	
esttab all_war all_war2 all_war3 all_war4 using t3.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model")  ///
	  	    varlabels(chall_tar_affin "Chal.-Target Affinity" def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger" tar_defense "Defense to Target" chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons) 
	
*Figure 2: Substantive Effect for Defensive Cultural Affinity in Table 3 War Model
	margins, at(def_affin_target=(-.5(0.5)2.5) tar_defense=(1))
			marginsplot, recast(line)    recastci(rarea) ciopt(color(%40)) ///
			 note(Shaded area represents 95% CI)   ///
				ylabel( #5, grid)  ///
				xlabel(-.5(.5)2.5)     ///
				ytitle("Probability of War Initiation")   ///
				xtitle("Cultural Affinity of Defense Alliance of Target")    ///
				graphregion(fcolor(white)) ///
				title("War Initiation by Affinity of Defense Alliance of Target", size(*1))  ///
				saving(war, replace)

*Table 4: Additional Dispute Models for 2 Dimension Measure	
logit dispute chal_tar_wo rel_power contig seqdispute  if pol_rel ==1, robust
	est store all_dis_new1
logit dispute chal_tar_wo tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1 , robust
	est store all_dis_new2
logit dispute chal_tar_wo tar_wo_def chal_wo_off chal_wo_neu rel_power contig seqdispute  if pol_rel ==1 , robust
	est store all_dis_new3
logit dispute chal_tar_wo tar_wo_def chal_wo_off chal_wo_neu tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1  , robust 
	est store all_dis_new4

esttab all_dis_new1 all_dis_new2 all_dis_new3 all_dis_new4 using t4.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model")  ///
	  	    varlabels(chal_tar_wo "Chal.-Target Affinity" tar_wo_def "Defense Affinity to Target" chal_wo_off "Offense Affinity to Challenger" chal_wo_neu  "Neutrality Affinity to Challenger" tar_defense Defense chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chal_tar_wo tar_wo_def chal_wo_off chal_wo_neu tar_defense chal_offense chal_neutral rel_power contig seqdispute  _cons)  
		
* Table 5: Additional War Models for 2 Dimension Measure	
logit war chal_tar_wo rel_power contig seqdispute  if pol_rel ==1, robust
	est store all_war_new1
logit war chal_tar_wo tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1 , robust
	est store all_war_new2
logit war chal_tar_wo tar_wo_def chal_wo_off chal_wo_neu rel_power contig seqdispute  if pol_rel ==1 , robust
	est store all_war_new3
logit war chal_tar_wo tar_wo_def chal_wo_off chal_wo_neu tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1  , robust 
	est store all_war_new4
	
esttab all_war_new1 all_war_new2 all_war_new3 all_war_new4 using t5.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model")  ///
	  	    varlabels(chal_tar_wo "Chal.-Target Affinity" tar_wo_def "Defense Affinity to Target" chal_wo_off "Offense Affinity to Challenger" chal_wo_neu  "Neutrality Affinity to Challenger" tar_defense Defense chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chal_tar_wo tar_wo_def chal_wo_off chal_wo_neu tar_defense chal_offense chal_neutral rel_power contig seqdispute  _cons)  
	
/* Appendix */
	
*Table A1: Dispute Initiation Model, Clustered SE by Dyad	
logit dispute chall_tar_affin rel_power contig seqdispute  if pol_rel ==1, cluster(chaltgt)
	est store all_dis_a1
logit dispute chall_tar_affin tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1 , cluster(chaltgt)
	est store all_dis_a2
logit dispute chall_tar_affin def_affin_target of_affin_chall neu_affin_chall rel_power contig seqdispute  if pol_rel ==1 , cluster(chaltgt)
	est store all_dis_a3
logit dispute chall_tar_affin def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1  , cluster(chaltgt)
	est store all_dis_a4
	esttab all_dis_a1 all_dis_a2 all_dis_a3 all_dis_a4 using a1.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model") ///
	   	    varlabels(chall_tar_affin "Chal.-Target Affinity" def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger"tar_defense "Defense to Target" chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Cahl.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)  

*Table A2: War Initiation Model, Clustered SE by Dyad
logit war chall_tar_affin rel_power contig seqdispute  if pol_rel ==1, cluster(chaltgt)
	est store all_war_a1
logit war chall_tar_affin tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1 , cluster(chaltgt)
	est store all_war_a2
logit war chall_tar_affin def_affin_target of_affin_chall neu_affin_chall rel_power contig seqdispute  if pol_rel ==1 , cluster(chaltgt)
	est store all_war_a3
logit war chall_tar_affin def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral rel_power contig seqdispute  if pol_rel ==1  , cluster(chaltgt)
	est store all_war_a4
	esttab all_war_a1 all_war_a2 all_war_a3 all_war_a4 using a2.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model") ///
	   	    varlabels(chall_tar_affin "Chal.-Target Affinity" def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger"tar_defense "Defense to Target" chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Cahl.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)  


*Table A3a-A3b: Bivariate Results for Dispute Initiation 
logit dispute chall_tar_affi if pol_rel ==1, robust 
est store biv1
logit dispute rel_power if pol_rel ==1, robust 
est store biv2
logit dispute contig if pol_rel ==1, robust 
est store biv3
logit dispute seqdispute if pol_rel ==1, robust 
est store biv4
logit dispute tar_defense if pol_rel ==1, robust 
est store biv5
logit dispute chal_offense if pol_rel ==1, robust 
est store biv6
logit dispute chal_neutral if pol_rel ==1, robust 
est store biv7
logit dispute def_affin_target if pol_rel ==1, robust 
est store biv8
logit dispute of_affin_chall if pol_rel ==1, robust 
est store biv9
logit dispute neu_affin_chall if pol_rel ==1, robust 
est store biv10

esttab biv1 biv2 biv3 biv4 biv5 using a3.rtf, replace se stat(N chi2 p)  label mtitles("Chal-Tgt Affinity" "Chal. Cap. Share" "Contiguity" "Peace Years" "Defense to Target")
esttab biv6 biv7 biv8 biv9 biv10 using a4.rtf, replace se stat(N chi2 p)  label mtitles("Offense to Challenger" "Neutrality to Challenger" "Defense Affinity" "Offense Affinity" "Neutrality Affinity")

*Table A4: Heckman Selection Model, Dispute Initiation
heckprobit dispute def_affin_target of_affin_chall neu_affin_chall seqdispute, sel(atopally=rel_pow contig)
est store hackman1
esttab hackman1 using a4.rtf, replace se stat(N chi2 p) 

*Table A5: Heckman Selection Model, War Initiation
heckprobit war def_affin_target of_affin_chall neu_affin_chall seqdispute, sel(atopally= rel_pow contig)
est store hackman2
esttab hackman2 using a5.rtf, replace  se stat(N chi2 p) 

*Table A6: Dispute Initiation Results, 1816-1945 and 1946-2016
logit dispute  chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall if pol_rel ==1  & year<1946 , robust
est store prewwii 
logit dispute  chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall if pol_rel ==1  & year>1945 , robust
est store postwwii
esttab prewwii postwwii using a6.rtf, replace se stat(N chi2) label mtitles("1816-1945" "1946-2016")
	
*Table A7: Dispute Initiation Model, with Fixed Effects
xtlogit dispute chall_tar_affin rel_power contig seqdispute if pol_rel ==1, fe
	est store fe_dispute
xtlogit dispute tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 , fe
	est store fe_dispute2
xtlogit dispute def_affin_target of_affin_chall neu_affin_chall chall_tar_affin rel_power contig seqdispute if pol_rel ==1 , fe
	est store fe_dispute3
xtlogit dispute def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1, fe
	est store fe_dispute4
	
esttab fe_dispute fe_dispute2 fe_dispute3 fe_dispute4 using a7.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model")  ///
	    varlabels(def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger" tar_defense "Defense to Target" chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Cahl.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)  

*Table A8: War Initiation Model, with Fixed Effects	
xtlogit  war chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & atopally == 1 , fe
	est store fe_war
xtlogit war tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & atopally == 1 , fe
	est store fe_war2
xtlogit war def_affin_target of_affin_chall neu_affin_chall chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & atopally == 1 , fe
	est store fe_war3
xtlogit war def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power  contig seqdispute if pol_rel ==1 & atopally == 1 , fe
	est store fe_war4
	
	esttab fe_war fe_war2 fe_war3 fe_war4 using a8.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity"  "Full Model")  ///
	    varlabels(def_affin_target "Defense Affinity to Target" of_affin_chall "Offense to Challenger" neu_affin_chall "Neutrality to Challenger" tar_defense Defense chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Cahl.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity"   seqdispute  "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)
	
*Table A9: Dispute Initiation Model Results Disaggregated by Regime Type
logit dispute def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & chall_polity > 5 & tar_polity > 5, robust
	est store jointdem
logit dispute def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & chall_polity < 6 & tar_polity > 5, robust	
	est store calnontardem
logit dispute def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1  & chall_polity > 5 & tar_polity < 6, robust	
	est store chaldemtarnon
logit dispute def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1  & chall_polity < 6 & tar_polity < 6, robust	
	est store nonnon

	esttab jointdem calnontardem chaldemtarnon nonnon using a9.rtf, replace se stat(N chi2 p) label mtitles("Target & Chal.  Democracies" "Target - Dem, Challenger - Nondem" "Target - Nondem, Challenger-Dem"  "Non-democracies" ) ///
	    varlabels(def_affin_target "Defense Affinity to Target" of_affin_chall "Offense to Challenger" neu_affin_chall "Neutrality to Challenger" tar_defense Defense chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Cahl.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity"  seqdispute  "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)  
		
*Table A10: War Initiation Model Results Disaggregated by Regime Type
logit war def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & atopally == 1 & chall_polity < 6 & tar_polity > 5, robust	
	est store calnontardemwar
logit war def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & atopally == 1 & chall_polity > 5 & tar_polity < 6, robust	
	est store chaldemtarnonwar
logit war def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & atopally == 1 & chall_polity < 6 & tar_polity < 6, robust	
	est store nonnonwar

	esttab calnontardemwar chaldemtarnonwar nonnonwar using a10.rtf, replace se stat(N chi2 p) label mtitles( "Target - Dem, Challenger - Nondem" "Target - Nondem, Challenger-Dem"  "Non-democracies" )     ///
	    varlabels(def_affin_target "Defense Affinity to Target" of_affin_chall "Offense to Challenger" neu_affin_chall "Neutrality to Challenger" tar_defense Defense chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Chal.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity"  seqdispute "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target  neu_affin_chall _cons)   
		
*Table A11: Dispute Initiation Model Dropping Dyads with Only Democratic Allies
logit dispute chall_tar_affin rel_power contig seqdispute if pol_rel ==1  & (target_audem ==1 | chal_audem==1) , robust
	est store autodem_no1
logit dispute tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & (target_audem ==1 | chal_audem==1), robust
	est store autodem_no2
logit dispute def_affin_target of_affin_chall neu_affin_chall chall_tar_affin rel_power contig seqdispute if pol_rel ==1  & (target_audem ==1 | chal_audem==1), robust
	est store autodem_no3
logit dispute def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & (target_audem ==1 | chal_audem==1), robust
	est store autodem_no4

	esttab autodem_no1 autodem_no2 autodem_no3 autodem_no4 using a11.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity" "Full Model") ///
	     varlabels(def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger" tar_defense  "Defense to Target"chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Chal.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute  "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)  
		 
	
*Table A12: War Initiation Model Dropping Dyads with Only Democratic Allies
logit war chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & (target_audem ==1 | chal_audem==1), robust
	est store autodem_war_no1
logit war tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & (target_audem ==1 | chal_audem==1), robust
	est store autodem_war_no2
logit war def_affin_target of_affin_chall neu_affin_chall chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & (target_audem ==1 | chal_audem==1), robust
	est store autodem_war_no3
logit war def_affin_target of_affin_chall neu_affin_chall tar_defense chal_offense chal_neutral chall_tar_affin rel_power contig seqdispute if pol_rel ==1 & (target_audem ==1 | chal_audem==1), robust
	est store autodem_war_no4

	esttab autodem_war_no1 autodem_war_no2 autodem_war_no3 autodem_war_no4 using a12.rtf, replace se stat(N chi2 p) label mtitles("Baseline" "Alliance Types" "Alliance Affinity" "Full Model") ///
	    varlabels(def_affin_target "Defense Affinity to Target" of_affin_chall "Offense Affinity to Challenger" neu_affin_chall "Neutrality Affinity to Challenger" tar_defense  "Defense to Target"chal_offense "Offense to Challenger" chal_neutral "Neutral to Challenger" chall_tar_affin "Chal.-Target Affinity" rel_power "Chal. Cap. Share" contig "Contiguity" seqdispute  "Peace Years" _cons Constant)  ///
	order(chall_tar_affin rel_power contig seqdispute tar_defense chal_offense chal_neutral def_affin_target of_affin_chall neu_affin_chall _cons)  
